varying vec2 		texCoord;		// Center
uniform vec2		invSize;
uniform sampler2D 	s_image;

float lumRGB(vec3 v)
{   
	return dot(v, vec3(0.212, 0.716, 0.072));	
}
 
void	main()
{
    //vec2    UV = tc0.xy * inverse_buffer_size;
	vec3	color;
    float   w = 1.00;
 
    float   t = lumRGB(texture2D(s_image, texCoord + vec2(0.0, -1.0) * w * invSize).xyz),
			l = lumRGB(texture2D(s_image, texCoord + vec2(-1.0, 0.0) * w * invSize).xyz),
			r = lumRGB(texture2D(s_image, texCoord + vec2(1.0, 0.0) * w * invSize).xyz),
			b = lumRGB(texture2D(s_image, texCoord + vec2(0.0, 1.0) * w * invSize).xyz);
 
    vec2    n = vec2(-(t - b), r - l);
    float   nl = length(n);
 
    if	(nl < (1.0 / 16.0))
	{
		gl_FragColor.rgb = /*pow(*/texture2D(s_image, texCoord).rgb;//,vec3(1.0/2.2));
	}
    else
    {
		n *= invSize / nl;
	 
		vec4	o = texture2D(s_image, texCoord),
				t0 = texture2D(s_image, texCoord + n * 0.5) * 0.9,
				t1 = texture2D(s_image, texCoord - n * 0.5) * 0.9,
				t2 = texture2D(s_image, texCoord + n) * 0.75,
				t3 = texture2D(s_image, texCoord - n) * 0.75;
	 
		color = (o.rgb + t0.rgb + t1.rgb + t2.rgb + t3.rgb) / 4.3;
		gl_FragColor.rgb=/*pow(*/color.rgb;//,vec3(1.0/2.2));
    }
	gl_FragColor.a=1.0;
}
